<?php
include("config_New.php");
if (!loggedin()) {
    header("Location: login.php");
    exit();
}
include 'PremiumFeatures.php';
include 'PremiumFeaturesImages.php';

$notPremiumFeaturesObj = new PremiumFeatures();
$allDataNotPremiumFeatures = $notPremiumFeaturesObj->getActiveNotPremium($_GET);
$featureImagesObj = new PremiumFeaturesImages();
?>
<!DOCTYPE html>
<html>
<?php include("include/heads.php"); ?>
<?php include("include/leftsidebar.php"); ?>
<style>
    #cssmenu {
        position: static;
    }
    .bg-pattern {
        background-color: white;
        background-size: cover;
    }
    .card {
        height: 450px;
        box-shadow: 0 0 35px 0 #667486;
        margin-bottom: 24px;
        position: relative;
        display: flex;
        flex-direction: column;
        min-width: 0;
        word-wrap: break-word;
        background-color: #fff;
        background-clip: border-box;
        border: 0 solid #f7f7f7;
        border-radius: .25rem;
    }
    .card-body {
        flex: 1 1 auto;
        padding: 1.5rem 1.5rem;
    }
</style>

<div class="wrapper">
    <div class="container">    <!-- Start content -->
        <!-- Page-Title -->
        <div class="col-sm-12" align="center">
            <h4 class="page-title"><?php echo 'Free Features' ;?></h4>
            <br><br>
        </div>
        <div class="row">
            <?php
            foreach ($allDataNotPremiumFeatures as $key => $row_select) {
                $id = $row_select['id'];
                $title_ar = $row_select['title_ar'];
                $title_en = $row_select['title_en'];
                $description_ar = htmlspecialchars_decode($row_select['description_ar']);
                $description_en = htmlspecialchars_decode($row_select['description_en']);
                $price = $row_select['price'];
                $type = $row_select['type'];
                $logo = $row_select['logo'];
                $video = $row_select['video'];
                $usage_for = json_decode($row_select['usage_for']);
                $row_Images = $featureImagesObj->getByIdImages($id);
                ?>
                <div class="col-lg-4">
                    <div class="card bg-pattern">
                        <div class="card-body">
                            <div class="text-center">
                                <img src="<?php echo $logo; ?>" alt="logo" class="avatar-xl rounded-circle mb-3" style="width: 120px;height: 120px">
                                <h4><?php echo $title_en ;?></h4>
                            </div>

                            <span style="height: 150px;">
                                <?php echo $description_en ;?>
                            </span>


                            <div class="row mt-4 text-center">
                                <div class="col-12">
                                    <h5 class="fw-normal text-muted"><?php  echo 'Free' ;?></h5>
                                    <!--<h4><?=$price." "?><?php echo 'BHD' ;?> </h4>-->
                                </div>
                            </div>
                            <?php
                            if(!empty($row_Images) || !empty($video)) {
                                ?>
                                <div class="text-center">
                                    <button type="button" class="btn" data-toggle="modal"
                                            data-target="#exampleModalLong<?php echo $key; ?>"
                                            style="background-color:#667486;color: white; ">
                                        <?php echo 'View more details';?>
                                    </button>
                                </div>
                                <?php
                            }
                            if(!empty($usage_for)) {
                            ?>
                            <div style="position: absolute;bottom: 10px;" class="text-right">
                                <?php
                                if (in_array("app", $usage_for)) {
                                    ?>
                                    <span class="badge"
                                          style="background-color: #880000;color: white; "><?php echo 'Mobile App' ;?></span>
                                    <?php
                                }
                                if (in_array("web", $usage_for)) {
                                    ?>
                                    <span class="badge"
                                          style="background-color: #880000;color: white; "><?php echo 'Control Panel' ;?></span>
                                    <?php
                                }
                                ?>
                            </div>
                            <?php
                            }
                            ?>
                        </div>
                    </div> <!-- end card -->
                </div>
                <!-- Modal -->
                <div class="modal fade" id="exampleModalLong<?php echo $key;?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <?php
                                if(!empty($row_Images)) {
                                    ?>
                                    <div class="row mt-4 text-center">
                                        <div class="col-12">
                                            <?php
                                            foreach ($row_Images as $key => $row) {
                                                $image = $row['image'];
                                                ?>
                                                <a href="<?php echo $image; ?>" target="_blank"><img
                                                            src="<?php echo $image; ?>" width="150"
                                                            height="200"></a>
                                                <?php
                                            }
                                            ?>
                                        </div>
                                    </div>
                                    <?php
                                }
                                if(!empty($video)) {
                                    ?>
                                    <div class="row mt-4 text-center">
                                        <div class="col-12">
                                            <a href="<?php echo $video; ?>" target="_blank">
                                                <video width="350" height="350" controls>
                                                    <source src="<?php echo $video; ?>">
                                                </video>
                                            </a>
                                        </div>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Modal -->
                <?php
            }
            ?>
                </div>
        </div>

    </div>


<?php include("include/footer_text.php"); ?>

<?php include("include/footer.php"); ?>


</body>
</html>
