<?php

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection = $con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

$required_parametrs = array("lang","client_id","search_word");
$errors = array();
foreach ($_GET as $key => $value) {
    if (in_array($key, $required_parametrs)) {
        $key = array_search($key, $required_parametrs);
        unset($required_parametrs[$key]);
    } else {
        $errors[] = "Parameter field is required:";
    }
}
$lang = $_GET['lang'];

if (count($required_parametrs) > 0) {
    //some parameters required
    $response["success"] = 0;
    if ($lang == "ar") {
        $response["message"] = "برجاء مراجعة الداتا المرسلة !";
    } else {
        $response["message"] = "Please Chech the required parameters";
    }
    $response["required_parameters"] = $required_parametrs;
} else {

    $response["success"] = 1;

    $lang = mysqli_real_escape_string($connection, trim($_GET['lang']));

    $search_word=mysqli_real_escape_string($connection, trim($_GET['search_word']));
    $client_id=mysqli_real_escape_string($connection, trim($_GET['client_id']));



    $response['product'] = subcategories_filter($lang , $client_id , $search_word);
    
}

echo json_encode($response, JSON_UNESCAPED_UNICODE);
?>
