<?php

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection = $con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

header('Content-Type: application/json');

$required_parametrs = array("lang");

$errors = array();


$Req = $_GET;

foreach ($Req as $key => $value) {
    if (in_array($key, $required_parametrs)) {
        $key = array_search($key, $required_parametrs);
        unset($required_parametrs[$key]);
    } else {
        $errors[] = "Parameter field is required:";
    }
}

if (count($required_parametrs) > 0) {
    //some parameters required
    $response["success"] = 0;
    if ($lang == "ar") {
        $response["message"] = "برجاء مراجعة الداتا المرسلة !";
    } else {
        $response["message"] = "Please Check the required parameters";
    }
    $response["required_parameters"] = $required_parametrs;
} else {
    $response["success"] = 1;
    $lang = mysqli_real_escape_string($connection, trim($_GET['lang']));


    $about_data = view_police($lang);
    $response["police"] = $about_data;
}

echo json_encode($response);
?>
