<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection = $con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

header('Content-Type: application/json');

if (isset($_GET['lang']) && $_GET['lang'] != '') {

    $lang = $_GET['lang'];
    $client_id = $_GET['client_id'];
    $response["success"] = 1;
    
    $response["slider"]=get_slider($client_id,$lang); 
    $response["latest"]=get_latest_products($client_id,$lang); 
    $response["categories"]=get_parent_categories($lang); 
    $response["offers"]=get_offers($client_id,$lang); 
    $response["most_selling"]=most_request_sub($client_id,$lang); 

    $response["popUp"]=getPopUpData($lang,$client_id);

} else {
    // no products found
    $response["success"] = 0;
    $response["message"] = "هناك بيانات مفقوده برجاء مراجعة بياناتك";
}

// echoing JSON response
echo json_encode($response);

?>