<?php

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection = $con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

header('Content-Type: application/json');


// get all products from products table

if (isset($_GET['lang']) && $_GET['lang'] != '') {

    $lang = $_GET['lang'];

    $result = $connection->query("SELECT * FROM `parent_categories` where `display`=1 order by `arrangement` asc")  or die(mysqli_error($connection));

// check for empty result
    if (mysqli_num_rows($result) > 0) {
        // looping through all results
        // products node
        $response["product"] = array();

        while ($row = mysqli_fetch_array($result)) {
            // temp user array
            $product = array();
            $product["parent_category_id"]  = $parent_category_id = $row["parent_category_id"];
            if ($lang == "ar") {
                $product["parent_category_name"] = $row["parent_category_name_ar"];
                $product["parent_category_desc"] = $row["parent_category_desc_ar"];
            } else {
                $product["parent_category_name"] = $row["parent_category_name"];
                $product["parent_category_desc"] = $row["parent_category_desc"];
            }
            $product["parent_category_image"] = $row["parent_category_image"];
            $product["type"] = $row["type"];
            $product["arrangement"] = $row["arrangement"];
            $product["addition_type"] = $row["addition_type"];
            $product["removes_type"] = $row["removes_type"];

            

            // push single product into final response array
            array_push($response["product"], $product);
        }
        // success
        $response["success"] = 1;


        // echoing JSON response
        echo json_encode($response);
    } else {

        $response["product"] = array();

        // temp user array
        $product = array();

        // success
        $response["success"] = 1;

        // echoing JSON response
        echo json_encode($response);
    }
} else {
    // no products found
    $response["success"] = 0;
    $response["message"] = "هناك بيانات مفقوده برجاء مراجعة بياناتك";

    // echo no users JSON
    echo json_encode($response);
}
?>