<?php

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection = $con->connect();

$connection->query("SET NAMES 'utf8mb4'");

$connection->query("SET CHARACTER SET utf8mb4");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

header('Content-Type: application/json');


// get all products from products table

if (isset($_GET['client_id'])) {
    $client_id = $_GET['client_id'];

    $result = $connection->query("SELECT * FROM `notifications` where `client_id`='$client_id' || `client_id`=0 ORDER BY `id` DESC")  or die(mysqli_error($connection));

// check for empty result
    if (mysqli_num_rows($result) > 0) {
        // looping through all results
        // products node
        $response["product"] = array();

        while ($row = mysqli_fetch_array($result)) {

            // temp user array
            $product = array();

            $product["id"] = $row["id"];
            $product["text"] = substr(is_null(json_decode($row['text'])) ? $row['text'] : json_decode($row['text']), 0, 30000);
            $product["date"] = $row["date"];
            $product["type"] = $row["type"];
            $product["text_id"] = $row["text_id"];

            // push single product into final response array
            array_push($response["product"], $product);
        }
        // success
        $response["success"] = 1;

        // echoing JSON response
        echo json_encode($response);
    } else {

        $response["product"] = array();

        // temp user array
        $product = array();

        // success
        $response["success"] = 1;

        // echoing JSON response
        echo json_encode($response);
    }
} else {
// no products found
    $response["success"] = 0;
    $response["message"] = "هناك بيانات مفقوده برجاء مراجعة بياناتك";

// echo no users JSON
    echo json_encode($response);
}
?>