<?php

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection = $con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

header('Content-Type: application/json');

// get all products from products table

$date_now = date('Y-m-d');

$result = $connection->query("SELECT * FROM `dish_of_day` where `show_date`='$date_now' ") or die(mysqli_error($connection));

// check for empty result
if (mysqli_num_rows($result) > 0) {
    // looping through all results
    // products node
    $response["product"] = array();

    while ($row = mysqli_fetch_array($result)) {

        // temp user array
        $product = array();

        $product["id"] = $row["id"];
        $product["parent_category_id"] = $parent_category_id = $row["parent_category_id"];

        $product["parent_category_name"] = get_category_name_from_id($parent_category_id);
        $product["sub_category_id"] = $sub_category_id = $row["sub_category_id"];

        $product["evaluate"] = resume_evaluate($sub_category_id);

        $product["sub_category_name"] = get_sub_category_name_from_id($sub_category_id);
        $product["show_date"] = $row["show_date"];

        $product["image"] = $row["image"];

        // push single product into final response array
        array_push($response["product"], $product);
    }
    // success

    $response["success"] = 1;

    // echoing JSON response
    echo json_encode($response);
} else {

    $response["product"] = array();

    // temp user array
    $product = array();

    // success
    $response["success"] = 1;

    // echoing JSON response
    echo json_encode($response);
}
?>