<?php

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection = $con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');
header('Content-Type: application/json');

$required_parametrs = array("lang");

$errors = array();


$Req = $_GET;

foreach ($Req as $key => $value) {
    if (in_array($key, $required_parametrs)) {
        $key = array_search($key, $required_parametrs);
        unset($required_parametrs[$key]);
    } else {
        $errors[] = "Parameter field is required:";
    }
}

if (count($required_parametrs) > 0) {
    //some parameters required
    $response["success"] = 0;
    if ($lang == "ar") {
        $response["message"] = "برجاء مراجعة الداتا المرسلة !";
    } else {
        $response["message"] = "Please Check the required parameters";
    }
    $response["required_parameters"] = $required_parametrs;
} else {

    $lang = mysqli_real_escape_string($connection, trim($_GET['lang']));
    $client_id = mysqli_real_escape_string($connection, trim($_GET['client_id']));

    $data = array();

    $sql = "SELECT `sub_categories`.*  FROM `sub_categories` LEFT JOIN `cart` ON `sub_categories`.`sub_category_id` = `cart`.`sub_category_id` where `cart`.`status`='1' AND `cart`.`client_id`='$client_id' ";
    $sql .= " GROUP BY `cart`.`sub_category_id` ORDER BY COUNT(`cart`.`cart_id`) DESC";

    $result = $connection->query($sql) or die(mysqli_error($connection));

// check for empty result
    if (mysqli_num_rows($result) > 0) {
        // looping through all results
        // products node
        while ($row = mysqli_fetch_assoc($result)) {

            $row = replace_null_values($row);

            if ($lang == "en") {
                $product['sub_category_name'] = $row['sub_category_name'];
            } else {
                $product['sub_category_name'] = $row['sub_category_name_ar'];
            }

            $data[] = $product;
        }
    }
}

$response["success"] = 1;
$response["data"] = $data;

echo json_encode($response, JSON_UNESCAPED_UNICODE);
?>