<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection = $con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');
header('Content-Type: application/json');


$required_parametrs = array("lang", "client_id", "search_key");

$errors = array();

$Req = $_GET;
$lang = mysqli_real_escape_string($connection, trim($Req['lang']));

foreach ($Req as $key => $value) {
    if (in_array($key, $required_parametrs)) {
        $key = array_search($key, $required_parametrs);
        unset($required_parametrs[$key]);
    } else {
        $errors[] = "Parameter field is required:";
    }
}


if (count($required_parametrs) > 0) {
    //some parameters required
    $response["success"] = 0;
    if ($lang == "ar") {
        $response["message"] = "هناك بيانات مفقوده برجاء مراجعة بياناتك";
    } else {
        $response["message"] = "check your inputs";
    }
    $response["required_parameters"] = $required_parametrs;
} else {
    
    $client_id = mysqli_real_escape_string($connection, trim($Req['client_id']))? : 0;
    $search_key = mysqli_real_escape_string($connection, trim($Req['search_key']))? : "";



    $add = $connection->query("INSERT INTO `client_search_key`(`client_id`,`search_key`) VALUES ('$client_id','$search_key')");

    if ($add) {
        $id = mysqli_insert_id($connection);

        $response["id"] = $id;
        $response["success"] = 1;


        if ($lang == "ar") {
            $response["message"] = "تم الإضافة بنجاح";
        } else {
            $response["message"] = "Added successfully";
        }
    } else {

        $response["success"] = 0;
        if ($lang == "ar") {
            $response["message"] = " خطأ في الأدخال ";
        } else {
            $response["message"] = "error Adding ";
        }
    }
}
echo json_encode($response, JSON_UNESCAPED_UNICODE);
?>
